#include "IDataStream.h"
#include "IErrors.h"
#include "MTExceptions.h"

//	IDataStream::IDataStream()
//	
//	constructor
IDataStream::IDataStream()
{
	
}

//	IDataStream::~IDataStream()
//	
//	destructor
IDataStream::~IDataStream()
{
	
}

//	UInt16 IDataStream::ReadIntelShort(void)
//	
//	default handler for reading a byte-reversed short
//	
//	returns short
UInt16 IDataStream::ReadIntelShort(void)
{
	UInt16	data;
	
	data = ReadShort();
	
	return	((data >> 8) & 0x00FF) |
			((data << 8) & 0xFF00);
}

//	UInt32 IDataStream::ReadIntelLong(void)
//	
//	default handler for reading a byte-reversed long
//	
//	returns long
UInt32 IDataStream::ReadIntelLong(void)
{
	UInt32	data;
	
	data = ReadLong();
	
	return	((data >> 24) & 0x000000FF) |
			((data >>  8) & 0x0000FF00) |
			((data <<  8) & 0x00FF0000) |
			((data << 24) & 0xFF000000);
}

//	void IDataStream::ReadString(char * buf, UInt32 maxLength)
//	
//	default handler for reading a c-string
//	
//	buf = buffer to fill
//	maxLength = buffer size
void IDataStream::ReadString(char * buf, UInt32 maxLength)
{
	char data;
	
	if(HitEOF())
		throw MTRangeException("Reached end of file");
	
	do
	{
		data = ReadChar();
		*buf++ = data;
	}
	while(maxLength-- && data && !HitEOF());
	
	if(data)
	{
		if(maxLength)
			*buf++ = 0;
		else
			*(buf - 1) = 0;
	}
}

//	void IDataStream::ReadPCString(char * buf, UInt32 maxLength)
//	
//	default handler for reading a PC (0x0D 0x0A newline) string
//	
//	buf = buffer to fill
//	maxLength = buffer size
void IDataStream::ReadPCString(char * buf, UInt32 maxLength)
{
	char	data;
	UInt8	found0D = 0;
	
	if(HitEOF())
		throw MTRangeException("Reached end of file");
	
	do
	{
		data = ReadChar();
		
		if(found0D)
		{
			if(data == 0x0A)
			{
				*buf++ = 0;
				
				return;
			}
			else
			{
				found0D = 0;
			}
		}
		
		if(data == 0x0D)
		{
			found0D = 1;
			continue;
		}
		
		*buf++ = data;
		maxLength--;
	}
	while(maxLength && !HitEOF());
	
	if(maxLength)
		*buf++ = 0;
	else
		*(buf - 1) = 0;
}

//	void IDataStream::ReadMacString(char * buf, UInt32 maxLength)
//	
//	default handler for reading a Mac (0x0D newline) string
//	
//	buf = buffer to fill
//	maxLength = buffer size
void IDataStream::ReadMacString(char * buf, UInt32 maxLength)
{
	char	data;
	
	if(HitEOF())
		throw MTRangeException("Reached end of file");
	
	do
	{
		data = ReadChar();
		
		if(data == 0x0D)
		{
			*buf++ = 0;
			
			return;
		}
		
		*buf++ = data;
		maxLength--;
	}
	while(maxLength && !HitEOF());
	
	if(maxLength)
		*buf++ = 0;
	else
		*(buf - 1) = 0;
}

//	void IDataStream::ReadUnixString(char * buf, UInt32 maxLength)
//	
//	default handler for reading a Unix (0x0A newline) string
//	
//	buf = buffer to fill
//	maxLength = buffer size
void IDataStream::ReadUnixString(char * buf, UInt32 maxLength)
{
	char	data;
	
	if(HitEOF())
		throw MTRangeException("Reached end of file");
	
	do
	{
		data = ReadChar();
		
		if(data == 0x0A)
		{
			*buf++ = 0;
			
			return;
		}
		
		*buf++ = data;
		maxLength--;
	}
	while(maxLength && !HitEOF());
	
	if(maxLength)
		*buf++ = 0;
	else
		*(buf - 1) = 0;
}

//	void IDataStream::ReadUnknownString(char * buf, UInt32 maxLength)
//	
//	default handler for reading an unknown platform newline string
//	
//	buf = buffer to fill
//	maxLength = buffer size
void IDataStream::ReadUnknownString(char * buf, UInt32 maxLength)
{
	char	data;
	UInt8	found0D = 0;
	
	if(HitEOF())
		throw MTRangeException("Reached end of file");
	
	do
	{
		data = ReadChar();
		
		if(found0D)
		{
			if(data != 0x0A)
			{
				SetPosition(GetPosition() - 1);
			}
			
			goto done;
		}
		
		if(data == 0x0D)
		{
			found0D = 1;
			continue;
		}
		
		if(data == 0x0A)
		{
			goto done;
		}
		
		*buf++ = data;
		maxLength--;
	}
	while(maxLength && !HitEOF());
	
	done:
	
	if(maxLength)
		*buf++ = 0;
	else
		*(buf - 1) = 0;
}

//	void IDataStream::WriteIntelShort(UInt16 data)
//	
//	default handler for writing a byte-reversed short
//	
//	data = short to write
void IDataStream::WriteIntelShort(UInt16 data)
{
	WriteShort(	((data >> 8) & 0x00FF) |
				((data << 8) & 0xFF00));
}

//	void IDataStream::WriteIntelLong(UInt32 data)
//	
//	default handler for writing a byte-reversed long
//	
//	data = long to write
void IDataStream::WriteIntelLong(UInt32 data)
{
	WriteLong(	((data >> 24) & 0x000000FF) |
				((data >>  8) & 0x0000FF00) |
				((data <<  8) & 0x00FF0000) |
				((data << 24) & 0xFF000000));
}

//	void IDataStream::WritePCString(char * buf)
//	
//	default handler for writing a PC (0x0D 0x0A newline) string
//	
//	buf = pointer to zero-terminated buffer to write
void IDataStream::WritePCString(char * buf)
{
	SInt32	length = std::strlen(buf);
	
	if(length > 0)
		WriteBuffer((UInt8 *)buf, length);
	
	WriteChar(0x0D);
	WriteChar(0x0A);
}

//	void IDataStream::WriteMacString(char * buf)
//	
//	default handler for writing a Mac (0x0D newline) string
//	
//	buf = pointer to zero-terminated buffer to write
void IDataStream::WriteMacString(char * buf)
{
	SInt32	length = std::strlen(buf);
	
	if(length > 0)
		WriteBuffer((UInt8 *)buf, length);
	
	WriteChar(0x0D);
}

//	void IDataStream::WriteUnixString(char * buf)
//	
//	default handler for writing a Unix (0x0A newline) string
//	
//	buf = pointer to zero-terminated buffer to write
void IDataStream::WriteUnixString(char * buf)
{
	SInt32	length = std::strlen(buf);
	
	if(length > 0)
		WriteBuffer((UInt8 *)buf, length);
	
	WriteChar(0x0A);
}